//=========================================================================================================
//
// Copyright 2002, 2003 Macromedia, Inc. All rights reserved.
//
// Feature: Paste Fix
// Author:  JDH
// Module:  DropOffice.js
// Purpose:	Called by the drag and drop mechanism in response to a file drop.
// Updates:
//	8/1/02 - Started file control
//
//=========================================================================================================

var helpDoc = MM.HELP_objDropOffice;

var g_file = null;
var g_returnArray = null;

function receiveArguments()
{
	g_file = arguments[0];
	g_returnArray = arguments[ 1 ];
}

function commandButtons()
{
   return new Array(MM.BTN_OK,         "run();window.close()",
                    MM.BTN_Cancel,     "window.close()",
                    MM.BTN_Help,       "displayHelp()" );
}

function initializeUI()
{
	var defVal = dw.getPreferenceString( "General Preferences", "Drop Office Default", "0" );

	document.theForm.opmode[ defVal ].checked = true;
	document.theForm.opmode[ defVal ].focus();
}

function run()
{
	if ( document.theForm.opmode[ 0 ].checked )
	{
		var ret = insertOfficeDoc( g_file, g_returnArray, true );
		dw.setPreferenceString( "General Preferences", "Drop Office Default", "0" );
	}
	else
	{
		if ( g_returnArray )
			g_returnArray[ 0 ] = false;
		dw.setPreferenceString( "General Preferences", "Drop Office Default", "1" );
	}

	if ( document.theForm.remember.checked )
	{
		if ( document.theForm.opmode[ 0 ].checked )
			dw.setPreferenceString( "General Preferences", "Drop Office Action", "content" );
		else
			dw.setPreferenceString( "General Preferences", "Drop Office Action", "link" );
	}
}
